<?php

/**
 * This is the model class for table "ZlecenieFirmyLog".
 *
 * The followings are the available columns in table 'ZlecenieFirmyLog':
 * @property double $id
 * @property double $idAdmina
 * @property double $idZlecenieFirmy
 * @property string $data
 * @property double $status
 */
class ZlecenieFirmyLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ZlecenieFirmyLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ZlecenieFirmyLog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idAdmina, idZlecenieFirmy', 'required'),
			array('idAdmina, idZlecenieFirmy', 'numerical'),
			array('data', 'safe'),

			array('id, idAdmina, idZlecenieFirmy, data, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'admin'=>array(self::BELONGS_TO, 'Admin', 'idAdmina'),
			'zlecenieFirmy'=>array(self::BELONGS_TO, 'ZlecenieFirmy', 'idZlecenieFirmy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('ZlecenieFirmyLog', 'id'),
			'idAdmina'=>Yii::t('ZlecenieFirmyLog', 'idAdmina'),
			'idZlecenieFirmy'=>Yii::t('ZlecenieFirmyLog', 'idZlecenieFirmy'),
			'data'=>Yii::t('ZlecenieFirmyLog', 'data'),
			'status'=>Yii::t('ZlecenieFirmyLog', 'status'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idAdmina', $this->idAdmina);
		$criteria->compare('idZlecenieFirmy', $this->idZlecenieFirmy);
		$criteria->compare('data', $this->data, true);
		$criteria->compare('status', $this->status);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}